/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.finder;

import com.google.common.collect.Sets;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinAsJavaSupport;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.asJava.finder.KtLightPackage;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J#\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0014J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0002J&\u0010\u001a\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J&\u0010\u001d\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019H\u0002JB\u0010\u001e\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!H\u0002J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0%2\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J#\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010(J#\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00122\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010+J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020*0-2\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J#\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00122\u0006\u0010&\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010/J\u001e\u00100\u001a\u00020\u00162\f\u00101\u001a\b\u0012\u0004\u0012\u00020\f022\u0006\u00103\u001a\u00020\u0010H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder;", "Lcom/intellij/psi/PsiElementFinder;", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinFinderMarker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "kotlinAsJavaSupport", "Lorg/jetbrains/kotlin/asJava/KotlinAsJavaSupport;", "psiManager", "Lcom/intellij/psi/PsiManager;", "Lorg/jetbrains/annotations/NotNull;", "findClass", "Lcom/intellij/psi/PsiClass;", "qualifiedName", "", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "findClasses", "", "qualifiedNameString", "(Ljava/lang/String;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiClass;", "findClassesAndObjects", "", "Lorg/jetbrains/kotlin/name/FqName;", "answer", "", "findInterfaceDefaultImpls", "findPackage", "Lcom/intellij/psi/PsiPackage;", "findRepeatableAnnotationContainer", "findSyntheticInnerClass", "syntheticName", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "", "getClassNames", "", "psiPackage", "getClasses", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiClass;", "getPackageFiles", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiFile;", "getPackageFilesFilter", "Lcom/intellij/openapi/util/Condition;", "getSubPackages", "(Lcom/intellij/psi/PsiPackage;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiPackage;", "sortByPreferenceToSourceFile", "list", "Lcom/intellij/util/SmartList;", "searchScope", "Companion", "light-classes"})
public final class JavaElementFinder
extends PsiElementFinder
implements KotlinFinderMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PsiManager psiManager;
    @NotNull
    private final KotlinAsJavaSupport kotlinAsJavaSupport;

    public JavaElementFinder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(project)");
        this.psiManager = psiManager;
        this.kotlinAsJavaSupport = KotlinAsJavaSupport.Companion.getInstance(this.project);
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        return (PsiClass)ArraysKt.firstOrNull((Object[])this.findClasses(qualifiedName, scope2));
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedNameString, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)qualifiedNameString, (String)"qualifiedNameString");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiClass.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiClass.EMPTY_ARRAY;
        }
        SmartList answer = new SmartList();
        FqName qualifiedName = new FqName(qualifiedNameString);
        this.findClassesAndObjects(qualifiedName, scope2, (List)answer);
        answer.addAll(this.kotlinAsJavaSupport.getFacadeClasses(qualifiedName, scope2));
        answer.addAll(this.kotlinAsJavaSupport.getKotlinInternalClasses(qualifiedName, scope2));
        this.sortByPreferenceToSourceFile((SmartList<PsiClass>)answer, scope2);
        Collection $this$toTypedArray$iv = (Collection)answer;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiClass[0]);
    }

    private final void findClassesAndObjects(FqName qualifiedName, GlobalSearchScope scope2, List<PsiClass> answer) {
        this.findInterfaceDefaultImpls(qualifiedName, scope2, answer);
        this.findRepeatableAnnotationContainer(qualifiedName, scope2, answer);
        Collection<KtClassOrObject> classOrObjectDeclarations = this.kotlinAsJavaSupport.findClassOrObjectDeclarations(qualifiedName, scope2);
        for (KtClassOrObject declaration : classOrObjectDeclarations) {
            KtLightClass lightClass;
            if (declaration instanceof KtEnumEntry || (lightClass = this.kotlinAsJavaSupport.getLightClass(declaration)) == null) continue;
            answer.add(lightClass);
        }
    }

    private final void findInterfaceDefaultImpls(FqName qualifiedName, GlobalSearchScope scope2, List<PsiClass> answer) {
        this.findSyntheticInnerClass(qualifiedName, "DefaultImpls", scope2, answer, (Function1<? super KtClassOrObject, Boolean>)((Function1)findInterfaceDefaultImpls.1.INSTANCE));
    }

    private final void findRepeatableAnnotationContainer(FqName qualifiedName, GlobalSearchScope scope2, List<PsiClass> answer) {
        this.findSyntheticInnerClass(qualifiedName, "Container", scope2, answer, (Function1<? super KtClassOrObject, Boolean>)((Function1)findRepeatableAnnotationContainer.1.INSTANCE));
    }

    private final void findSyntheticInnerClass(FqName qualifiedName, String syntheticName, GlobalSearchScope scope2, List<PsiClass> answer, Function1<? super KtClassOrObject, Boolean> predicate) {
        if (qualifiedName.isRoot() || !Intrinsics.areEqual((Object)qualifiedName.shortName().asString(), (Object)syntheticName)) {
            return;
        }
        FqName fqName = qualifiedName.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"qualifiedName.parent()");
        for (KtClassOrObject classOrObject : this.kotlinAsJavaSupport.findClassOrObjectDeclarations(fqName, scope2)) {
            PsiClass implsClass;
            KtLightClass interfaceClass;
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            if (!((Boolean)predicate.invoke((Object)classOrObject)).booleanValue() || this.kotlinAsJavaSupport.getLightClass(classOrObject) == null || interfaceClass.findInnerClassByName(syntheticName, false) == null) continue;
            answer.add(implsClass);
        }
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        Collection<KtClassOrObject> declarations = this.kotlinAsJavaSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope2);
        HashSet answer = Sets.newHashSet();
        answer.addAll(this.kotlinAsJavaSupport.getFacadeNames(packageFQN, scope2));
        for (KtClassOrObject declaration : declarations) {
            String name;
            if (declaration.getName() == null) continue;
            answer.add(name);
        }
        Intrinsics.checkNotNullExpressionValue((Object)answer, (String)"answer");
        return answer;
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedNameString) {
        Intrinsics.checkNotNullParameter((Object)qualifiedNameString, (String)"qualifiedNameString");
        if (!FqNamesUtilKt.isValidJavaFqName(qualifiedNameString)) {
            return null;
        }
        FqName fqName = new FqName(qualifiedNameString);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(project)");
        GlobalSearchScope allScope = globalSearchScope;
        return this.kotlinAsJavaSupport.packageExists(fqName, allScope) ? (PsiPackage)new KtLightPackage(this.psiManager, fqName, allScope) : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Collection<FqName> subpackages = this.kotlinAsJavaSupport.getSubPackages(new FqName(psiPackage.getQualifiedName()), scope2);
        Iterable $this$map$iv = subpackages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FqName fqName = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new KtLightPackage(this.psiManager, (FqName)it, scope2));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiPackage[0]);
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        SmartList answer = new SmartList();
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        answer.addAll(this.kotlinAsJavaSupport.getFacadeClassesInPackage(packageFQN, scope2));
        Collection<KtClassOrObject> declarations = this.kotlinAsJavaSupport.findClassOrObjectDeclarationsInPackage(packageFQN, scope2);
        for (KtClassOrObject declaration : declarations) {
            KtLightClass aClass;
            if (this.kotlinAsJavaSupport.getLightClass(declaration) == null) continue;
            answer.add((Object)aClass);
        }
        this.sortByPreferenceToSourceFile((SmartList<PsiClass>)answer, scope2);
        Collection $this$toTypedArray$iv = (Collection)answer;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiClass[0]);
    }

    private final void sortByPreferenceToSourceFile(SmartList<PsiClass> list, GlobalSearchScope searchScope) {
        if (list.size() < 2) {
            return;
        }
        ContainerUtil.quickSort((List)((List)list), Companion.byClasspathComparator(searchScope));
        List $this$sortBy$iv = (List)list;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PsiClass it = (PsiClass)a;
                    boolean bl = false;
                    boolean bl2 = !(it instanceof ClsClassImpl);
                    it = (PsiClass)b;
                    Comparable comparable = Boolean.valueOf(bl2);
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(!(it instanceof ClsClassImpl)));
                }
            });
        }
    }

    @NotNull
    public PsiFile[] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Collection<KtFile> $this$toTypedArray$iv = this.kotlinAsJavaSupport.findFilesForPackage(new FqName(psiPackage.getQualifiedName()), scope2);
        boolean $i$f$toTypedArray = false;
        Collection<KtFile> thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiFile[0]);
    }

    @NotNull
    public Condition<PsiFile> getPackageFilesFilter(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)psiPackage, (String)"psiPackage");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        return arg_0 -> JavaElementFinder.getPackageFilesFilter$lambda$2(psiPackage, arg_0);
    }

    private static final boolean getPackageFilesFilter$lambda$2(PsiPackage $psiPackage, PsiFile input) {
        Intrinsics.checkNotNullParameter((Object)$psiPackage, (String)"$psiPackage");
        return !(input instanceof KtFile) ? true : Intrinsics.areEqual((Object)$psiPackage.getQualifiedName(), (Object)((KtFile)input).getPackageFqName().asString());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder$Companion;", "", "()V", "byClasspathComparator", "Ljava/util/Comparator;", "Lcom/intellij/psi/PsiElement;", "Lkotlin/Comparator;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getInstance", "Lorg/jetbrains/kotlin/asJava/finder/JavaElementFinder;", "project", "Lcom/intellij/openapi/project/Project;", "light-classes"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaElementFinder getInstance(@NotNull Project project) {
            Object object;
            block2: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Object[] objectArray = PsiElementFinder.EP.getPoint((AreaInstance)project).getExtensions();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"EP.getPoint(project).extensions");
                Object[] $this$firstIsInstanceOrNull$iv = objectArray;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof JavaElementFinder)) continue;
                    object = element$iv;
                    break block2;
                }
                object = null;
            }
            JavaElementFinder javaElementFinder = (JavaElementFinder)object;
            if (javaElementFinder == null) {
                throw new IllegalStateException((JavaElementFinder.class.getSimpleName() + " is not found for project " + project).toString());
            }
            return javaElementFinder;
        }

        @NotNull
        public final Comparator<PsiElement> byClasspathComparator(@NotNull GlobalSearchScope searchScope) {
            Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
            return (arg_0, arg_1) -> Companion.byClasspathComparator$lambda$0(searchScope, arg_0, arg_1);
        }

        private static final int byClasspathComparator$lambda$0(GlobalSearchScope $searchScope, PsiElement o1, PsiElement o2) {
            Intrinsics.checkNotNullParameter((Object)$searchScope, (String)"$searchScope");
            VirtualFile f1 = PsiUtilCore.getVirtualFile((PsiElement)o1);
            VirtualFile f2 = PsiUtilCore.getVirtualFile((PsiElement)o2);
            return f1 == f2 ? 0 : (f1 == null ? -1 : (f2 == null ? 1 : $searchScope.compare(f2, f1)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

