/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.references.KtSimpleReference;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b&\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0014B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtInvokeFunctionReference;", "Lorg/jetbrains/kotlin/idea/references/KtSimpleReference;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lcom/intellij/psi/MultiRangeReference;", "expression", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "resolvesByNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getResolvesByNames", "()Ljava/util/Collection;", "canRename", "", "getRange", "Lcom/intellij/openapi/util/TextRange;", "node", "Lcom/intellij/lang/ASTNode;", "getRangeInElement", "getRanges", "", "Companion", "kt-references"})
public abstract class KtInvokeFunctionReference
extends KtSimpleReference<KtCallExpression>
implements MultiRangeReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<Name> NAMES = CollectionsKt.listOf((Object)OperatorNameConventions.INVOKE);

    public KtInvokeFunctionReference(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super((KtReferenceExpression)expression);
    }

    @Override
    @NotNull
    public Collection<Name> getResolvesByNames() {
        return NAMES;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = ((KtCallExpression)this.getElement()).getTextRange().shiftRight(-((KtCallExpression)this.getElement()).getTextOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange.shiftRight(-element.textOffset)");
        return textRange;
    }

    @NotNull
    public List<TextRange> getRanges() {
        ArrayList<TextRange> list = new ArrayList<TextRange>();
        KtValueArgumentList valueArgumentList = ((KtCallExpression)this.getExpression()).getValueArgumentList();
        if (valueArgumentList != null) {
            List<KtValueArgument> list2 = valueArgumentList.getArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"valueArgumentList.arguments");
            if (!((Collection)list2).isEmpty()) {
                ASTNode rPar;
                ASTNode aSTNode = valueArgumentList.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"valueArgumentList.node");
                ASTNode valueArgumentListNode = aSTNode;
                ASTNode lPar = valueArgumentListNode.findChildByType((IElementType)KtTokens.LPAR);
                if (lPar != null) {
                    list.add(this.getRange(lPar));
                }
                if ((rPar = valueArgumentListNode.findChildByType((IElementType)KtTokens.RPAR)) != null) {
                    list.add(this.getRange(rPar));
                }
            } else {
                ASTNode aSTNode = valueArgumentList.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"valueArgumentList.node");
                list.add(this.getRange(aSTNode));
            }
        }
        List<KtLambdaArgument> list3 = ((KtCallExpression)this.getExpression()).getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"expression.lambdaArguments");
        List<KtLambdaArgument> functionLiteralArguments = list3;
        for (KtLambdaArgument functionLiteralArgument : functionLiteralArguments) {
            KtLambdaExpression functionLiteralExpression;
            if (functionLiteralArgument.getLambdaExpression() == null) continue;
            ASTNode aSTNode = functionLiteralExpression.getLeftCurlyBrace();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"functionLiteralExpression.leftCurlyBrace");
            list.add(this.getRange(aSTNode));
            ASTNode rightCurlyBrace = functionLiteralExpression.getRightCurlyBrace();
            if (rightCurlyBrace == null) continue;
            list.add(this.getRange(rightCurlyBrace));
        }
        return list;
    }

    private final TextRange getRange(ASTNode node) {
        TextRange textRange = node.getTextRange();
        TextRange textRange2 = textRange.shiftRight(-((KtCallExpression)this.getExpression()).getTextOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"textRange.shiftRight(-expression.textOffset)");
        return textRange2;
    }

    @Override
    public boolean canRename() {
        return true;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtInvokeFunctionReference$Companion;", "", "()V", "NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "kt-references"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

