/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins.jvm;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.load.kotlin.SignatureBuildingComponents;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/builtins/jvm/JvmBuiltInsSignatures;", "", "()V", "DROP_LIST_METHOD_SIGNATURES", "", "", "getDROP_LIST_METHOD_SIGNATURES", "()Ljava/util/Set;", "HIDDEN_CONSTRUCTOR_SIGNATURES", "getHIDDEN_CONSTRUCTOR_SIGNATURES", "HIDDEN_METHOD_SIGNATURES", "getHIDDEN_METHOD_SIGNATURES", "MUTABLE_METHOD_SIGNATURES", "getMUTABLE_METHOD_SIGNATURES", "VISIBLE_CONSTRUCTOR_SIGNATURES", "getVISIBLE_CONSTRUCTOR_SIGNATURES", "VISIBLE_METHOD_SIGNATURES", "getVISIBLE_METHOD_SIGNATURES", "buildPrimitiveStringConstructorsSet", "buildPrimitiveValueMethodsSet", "isArrayOrPrimitiveArray", "", "fqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "isSerializableInJava", "compiler.common.jvm"})
public final class JvmBuiltInsSignatures {
    @NotNull
    public static final JvmBuiltInsSignatures INSTANCE = new JvmBuiltInsSignatures();
    @NotNull
    private static final Set<String> DROP_LIST_METHOD_SIGNATURES;
    @NotNull
    private static final Set<String> HIDDEN_METHOD_SIGNATURES;
    @NotNull
    private static final Set<String> VISIBLE_METHOD_SIGNATURES;
    @NotNull
    private static final Set<String> MUTABLE_METHOD_SIGNATURES;
    @NotNull
    private static final Set<String> HIDDEN_CONSTRUCTOR_SIGNATURES;
    @NotNull
    private static final Set<String> VISIBLE_CONSTRUCTOR_SIGNATURES;

    private JvmBuiltInsSignatures() {
    }

    @NotNull
    public final Set<String> getDROP_LIST_METHOD_SIGNATURES() {
        return DROP_LIST_METHOD_SIGNATURES;
    }

    @NotNull
    public final Set<String> getHIDDEN_METHOD_SIGNATURES() {
        return HIDDEN_METHOD_SIGNATURES;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> buildPrimitiveValueMethodsSet() {
        void $this$flatMapTo$iv;
        boolean $i$f$signatures = false;
        SignatureBuildingComponents $this$buildPrimitiveValueMethodsSet_u24lambda_u242 = SignatureBuildingComponents.INSTANCE;
        boolean bl = false;
        Object object = new JvmPrimitiveType[]{JvmPrimitiveType.BOOLEAN, JvmPrimitiveType.CHAR};
        object = CollectionsKt.listOf((Object[])object);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            JvmPrimitiveType it = (JvmPrimitiveType)((Object)element$iv);
            boolean bl2 = false;
            String string = it.getWrapperFqName().shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.wrapperFqName.shortName().asString()");
            String[] stringArray = new String[]{it.getJavaKeywordName() + "Value()" + it.getDesc()};
            Iterable list$iv = $this$buildPrimitiveValueMethodsSet_u24lambda_u242.inJavaLang(string, stringArray);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (LinkedHashSet)destination$iv;
    }

    @NotNull
    public final Set<String> getVISIBLE_METHOD_SIGNATURES() {
        return VISIBLE_METHOD_SIGNATURES;
    }

    @NotNull
    public final Set<String> getMUTABLE_METHOD_SIGNATURES() {
        return MUTABLE_METHOD_SIGNATURES;
    }

    @NotNull
    public final Set<String> getHIDDEN_CONSTRUCTOR_SIGNATURES() {
        return HIDDEN_CONSTRUCTOR_SIGNATURES;
    }

    @NotNull
    public final Set<String> getVISIBLE_CONSTRUCTOR_SIGNATURES() {
        return VISIBLE_CONSTRUCTOR_SIGNATURES;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> buildPrimitiveStringConstructorsSet() {
        void $this$flatMapTo$iv;
        boolean $i$f$signatures = false;
        SignatureBuildingComponents $this$buildPrimitiveStringConstructorsSet_u24lambda_u248 = SignatureBuildingComponents.INSTANCE;
        boolean bl = false;
        Object object = new JvmPrimitiveType[]{JvmPrimitiveType.BOOLEAN, JvmPrimitiveType.BYTE, JvmPrimitiveType.DOUBLE, JvmPrimitiveType.FLOAT, JvmPrimitiveType.BYTE, JvmPrimitiveType.INT, JvmPrimitiveType.LONG, JvmPrimitiveType.SHORT};
        object = CollectionsKt.listOf((Object[])object);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            JvmPrimitiveType it = (JvmPrimitiveType)((Object)element$iv);
            boolean bl2 = false;
            String string = it.getWrapperFqName().shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.wrapperFqName.shortName().asString()");
            String[] stringArray = new String[]{"Ljava/lang/String;"};
            String[] stringArray2 = $this$buildPrimitiveStringConstructorsSet_u24lambda_u248.constructors(stringArray);
            Iterable list$iv = $this$buildPrimitiveStringConstructorsSet_u24lambda_u248.inJavaLang(string, Arrays.copyOf(stringArray2, stringArray2.length));
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (LinkedHashSet)destination$iv;
    }

    public final boolean isSerializableInJava(@NotNull FqNameUnsafe fqName) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        if (this.isArrayOrPrimitiveArray(fqName)) {
            return true;
        }
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqName);
        if (classId == null) {
            return false;
        }
        ClassId javaClassId = classId;
        try {
            clazz = Class.forName(javaClassId.asSingleFqName().asString());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        Class<?> classViaReflection = clazz;
        return Serializable.class.isAssignableFrom(classViaReflection);
    }

    public final boolean isArrayOrPrimitiveArray(@NotNull FqNameUnsafe fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        return Intrinsics.areEqual((Object)fqName, (Object)StandardNames.FqNames.array) || StandardNames.isPrimitiveArray(fqName);
    }

    static {
        String[] stringArray = new String[]{"toArray()[Ljava/lang/Object;", "toArray([Ljava/lang/Object;)[Ljava/lang/Object;"};
        DROP_LIST_METHOD_SIGNATURES = SetsKt.plus(SignatureBuildingComponents.INSTANCE.inJavaUtil("Collection", stringArray), (Object)"java/lang/annotation/Annotation.annotationType()Ljava/lang/Class;");
        boolean $i$f$signatures = false;
        SignatureBuildingComponents $this$HIDDEN_METHOD_SIGNATURES_u24lambda_u240 = SignatureBuildingComponents.INSTANCE;
        boolean bl = false;
        String[] stringArray2 = new String[]{"sort(Ljava/util/Comparator;)V"};
        Set set = SetsKt.plus(INSTANCE.buildPrimitiveValueMethodsSet(), (Iterable)$this$HIDDEN_METHOD_SIGNATURES_u24lambda_u240.inJavaUtil("List", stringArray2));
        stringArray2 = new String[]{"codePointAt(I)I", "codePointBefore(I)I", "codePointCount(II)I", "compareToIgnoreCase(Ljava/lang/String;)I", "concat(Ljava/lang/String;)Ljava/lang/String;", "contains(Ljava/lang/CharSequence;)Z", "contentEquals(Ljava/lang/CharSequence;)Z", "contentEquals(Ljava/lang/StringBuffer;)Z", "endsWith(Ljava/lang/String;)Z", "equalsIgnoreCase(Ljava/lang/String;)Z", "getBytes()[B", "getBytes(II[BI)V", "getBytes(Ljava/lang/String;)[B", "getBytes(Ljava/nio/charset/Charset;)[B", "getChars(II[CI)V", "indexOf(I)I", "indexOf(II)I", "indexOf(Ljava/lang/String;)I", "indexOf(Ljava/lang/String;I)I", "intern()Ljava/lang/String;", "isEmpty()Z", "lastIndexOf(I)I", "lastIndexOf(II)I", "lastIndexOf(Ljava/lang/String;)I", "lastIndexOf(Ljava/lang/String;I)I", "matches(Ljava/lang/String;)Z", "offsetByCodePoints(II)I", "regionMatches(ILjava/lang/String;II)Z", "regionMatches(ZILjava/lang/String;II)Z", "replaceAll(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "replace(CC)Ljava/lang/String;", "replaceFirst(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "replace(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;", "split(Ljava/lang/String;I)[Ljava/lang/String;", "split(Ljava/lang/String;)[Ljava/lang/String;", "startsWith(Ljava/lang/String;I)Z", "startsWith(Ljava/lang/String;)Z", "substring(II)Ljava/lang/String;", "substring(I)Ljava/lang/String;", "toCharArray()[C", "toLowerCase()Ljava/lang/String;", "toLowerCase(Ljava/util/Locale;)Ljava/lang/String;", "toUpperCase()Ljava/lang/String;", "toUpperCase(Ljava/util/Locale;)Ljava/lang/String;", "trim()Ljava/lang/String;", "isBlank()Z", "lines()Ljava/util/stream/Stream;", "repeat(I)Ljava/lang/String;"};
        Set set2 = SetsKt.plus((Set)set, (Iterable)$this$HIDDEN_METHOD_SIGNATURES_u24lambda_u240.inJavaLang("String", stringArray2));
        stringArray2 = new String[]{"isInfinite()Z", "isNaN()Z"};
        Set set3 = SetsKt.plus((Set)set2, (Iterable)$this$HIDDEN_METHOD_SIGNATURES_u24lambda_u240.inJavaLang("Double", stringArray2));
        stringArray2 = new String[]{"isInfinite()Z", "isNaN()Z"};
        Set set4 = SetsKt.plus((Set)set3, (Iterable)$this$HIDDEN_METHOD_SIGNATURES_u24lambda_u240.inJavaLang("Float", stringArray2));
        stringArray2 = new String[]{"getDeclaringClass()Ljava/lang/Class;", "finalize()V"};
        Set set5 = SetsKt.plus((Set)set4, (Iterable)$this$HIDDEN_METHOD_SIGNATURES_u24lambda_u240.inJavaLang("Enum", stringArray2));
        stringArray2 = new String[]{"isEmpty()Z"};
        HIDDEN_METHOD_SIGNATURES = SetsKt.plus((Set)set5, (Iterable)$this$HIDDEN_METHOD_SIGNATURES_u24lambda_u240.inJavaLang("CharSequence", stringArray2));
        $i$f$signatures = false;
        SignatureBuildingComponents $this$VISIBLE_METHOD_SIGNATURES_u24lambda_u243 = SignatureBuildingComponents.INSTANCE;
        boolean bl2 = false;
        stringArray2 = new String[]{"codePoints()Ljava/util/stream/IntStream;", "chars()Ljava/util/stream/IntStream;"};
        Set<String> set6 = $this$VISIBLE_METHOD_SIGNATURES_u24lambda_u243.inJavaLang("CharSequence", stringArray2);
        stringArray2 = new String[]{"forEachRemaining(Ljava/util/function/Consumer;)V"};
        Set set7 = SetsKt.plus(set6, (Iterable)$this$VISIBLE_METHOD_SIGNATURES_u24lambda_u243.inJavaUtil("Iterator", stringArray2));
        stringArray2 = new String[]{"forEach(Ljava/util/function/Consumer;)V", "spliterator()Ljava/util/Spliterator;"};
        Set set8 = SetsKt.plus((Set)set7, (Iterable)$this$VISIBLE_METHOD_SIGNATURES_u24lambda_u243.inJavaLang("Iterable", stringArray2));
        stringArray2 = new String[]{"setStackTrace([Ljava/lang/StackTraceElement;)V", "fillInStackTrace()Ljava/lang/Throwable;", "getLocalizedMessage()Ljava/lang/String;", "printStackTrace()V", "printStackTrace(Ljava/io/PrintStream;)V", "printStackTrace(Ljava/io/PrintWriter;)V", "getStackTrace()[Ljava/lang/StackTraceElement;", "initCause(Ljava/lang/Throwable;)Ljava/lang/Throwable;", "getSuppressed()[Ljava/lang/Throwable;", "addSuppressed(Ljava/lang/Throwable;)V"};
        Set set9 = SetsKt.plus((Set)set8, (Iterable)$this$VISIBLE_METHOD_SIGNATURES_u24lambda_u243.inJavaLang("Throwable", stringArray2));
        stringArray2 = new String[]{"spliterator()Ljava/util/Spliterator;", "parallelStream()Ljava/util/stream/Stream;", "stream()Ljava/util/stream/Stream;", "removeIf(Ljava/util/function/Predicate;)Z"};
        Set set10 = SetsKt.plus((Set)set9, (Iterable)$this$VISIBLE_METHOD_SIGNATURES_u24lambda_u243.inJavaUtil("Collection", stringArray2));
        stringArray2 = new String[]{"replaceAll(Ljava/util/function/UnaryOperator;)V"};
        Set set11 = SetsKt.plus((Set)set10, (Iterable)$this$VISIBLE_METHOD_SIGNATURES_u24lambda_u243.inJavaUtil("List", stringArray2));
        stringArray2 = new String[]{"getOrDefault(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "forEach(Ljava/util/function/BiConsumer;)V", "replaceAll(Ljava/util/function/BiFunction;)V", "merge(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "computeIfPresent(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "putIfAbsent(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "replace(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z", "replace(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;", "compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;"};
        VISIBLE_METHOD_SIGNATURES = SetsKt.plus((Set)set11, (Iterable)$this$VISIBLE_METHOD_SIGNATURES_u24lambda_u243.inJavaUtil("Map", stringArray2));
        $i$f$signatures = false;
        SignatureBuildingComponents $this$MUTABLE_METHOD_SIGNATURES_u24lambda_u244 = SignatureBuildingComponents.INSTANCE;
        boolean bl3 = false;
        stringArray2 = new String[]{"removeIf(Ljava/util/function/Predicate;)Z"};
        Set<String> set12 = $this$MUTABLE_METHOD_SIGNATURES_u24lambda_u244.inJavaUtil("Collection", stringArray2);
        stringArray2 = new String[]{"replaceAll(Ljava/util/function/UnaryOperator;)V", "sort(Ljava/util/Comparator;)V"};
        Set set13 = SetsKt.plus(set12, (Iterable)$this$MUTABLE_METHOD_SIGNATURES_u24lambda_u244.inJavaUtil("List", stringArray2));
        stringArray2 = new String[]{"computeIfAbsent(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;", "computeIfPresent(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "compute(Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "merge(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/function/BiFunction;)Ljava/lang/Object;", "putIfAbsent(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "remove(Ljava/lang/Object;Ljava/lang/Object;)Z", "replaceAll(Ljava/util/function/BiFunction;)V", "replace(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "replace(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Z"};
        MUTABLE_METHOD_SIGNATURES = SetsKt.plus((Set)set13, (Iterable)$this$MUTABLE_METHOD_SIGNATURES_u24lambda_u244.inJavaUtil("Map", stringArray2));
        $i$f$signatures = false;
        SignatureBuildingComponents $this$HIDDEN_CONSTRUCTOR_SIGNATURES_u24lambda_u245 = SignatureBuildingComponents.INSTANCE;
        boolean bl4 = false;
        stringArray2 = new String[]{"D"};
        String[] stringArray3 = $this$HIDDEN_CONSTRUCTOR_SIGNATURES_u24lambda_u245.constructors(stringArray2);
        Set set14 = SetsKt.plus(INSTANCE.buildPrimitiveStringConstructorsSet(), (Iterable)$this$HIDDEN_CONSTRUCTOR_SIGNATURES_u24lambda_u245.inJavaLang("Float", Arrays.copyOf(stringArray3, stringArray3.length)));
        stringArray2 = new String[]{"[C", "[CII", "[III", "[BIILjava/lang/String;", "[BIILjava/nio/charset/Charset;", "[BLjava/lang/String;", "[BLjava/nio/charset/Charset;", "[BII", "[B", "Ljava/lang/StringBuffer;", "Ljava/lang/StringBuilder;"};
        stringArray3 = $this$HIDDEN_CONSTRUCTOR_SIGNATURES_u24lambda_u245.constructors(stringArray2);
        HIDDEN_CONSTRUCTOR_SIGNATURES = SetsKt.plus((Set)set14, (Iterable)$this$HIDDEN_CONSTRUCTOR_SIGNATURES_u24lambda_u245.inJavaLang("String", Arrays.copyOf(stringArray3, stringArray3.length)));
        $i$f$signatures = false;
        SignatureBuildingComponents $this$VISIBLE_CONSTRUCTOR_SIGNATURES_u24lambda_u246 = SignatureBuildingComponents.INSTANCE;
        boolean bl5 = false;
        stringArray2 = new String[]{"Ljava/lang/String;Ljava/lang/Throwable;ZZ"};
        stringArray3 = $this$VISIBLE_CONSTRUCTOR_SIGNATURES_u24lambda_u246.constructors(stringArray2);
        VISIBLE_CONSTRUCTOR_SIGNATURES = $this$VISIBLE_CONSTRUCTOR_SIGNATURES_u24lambda_u246.inJavaLang("Throwable", Arrays.copyOf(stringArray3, stringArray3.length));
    }
}

