/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.client;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.UnmarshalException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.FileTreeWalk;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CompilerSystemProperties;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.daemon.client.BasicCompilerServicesWithResultsFacadeServer;
import org.jetbrains.kotlin.daemon.client.CompilationServices;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.client.CompilerCallbackServicesFacadeServer;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClientKt;
import org.jetbrains.kotlin.daemon.client.NativePlatformUtilKt;
import org.jetbrains.kotlin.daemon.client.RemoteOutputStreamServer;
import org.jetbrains.kotlin.daemon.common.BoolPropMapper;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerMode;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.FileAgeComparator;
import org.jetbrains.kotlin.daemon.common.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.common.OptionsGroup;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.PropMapper;
import org.jetbrains.kotlin.daemon.common.RemoteOperationsTracer;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001YB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JS\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00042\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007\u00a2\u0006\u0002\u0010\u001dJ\u0087\u0001\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\"\b\u0002\u0010 \u001a\u001c\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0#\u0012\u0004\u0012\u00020$\u0018\u00010!2\b\b\u0002\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(2\b\b\u0002\u0010\u001a\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020*\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020-H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002JL\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\"2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020\f2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\"J<\u0010=\u001a\u0004\u0018\u0001H>\"\u0004\b\u0000\u0010>2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\f2\u0014\u0010?\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u0001H>0@H\u0082\b\u00a2\u0006\u0002\u0010AJ:\u0010B\u001a\u0004\u0018\u00010\u00112\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\"2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\b\b\u0002\u0010:\u001a\u00020\fJ<\u0010B\u001a\u0004\u0018\u00010\u00112\u0006\u00101\u001a\u0002022\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\b\b\u0002\u0010:\u001a\u00020\f2\b\b\u0002\u0010C\u001a\u00020\fJ\u000e\u0010D\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010#J\u000e\u0010E\u001a\u00020\"2\u0006\u00106\u001a\u000207Jm\u0010F\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u00192\u0006\u0010K\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u00042\b\b\u0002\u0010)\u001a\u00020*2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007\u00a2\u0006\u0002\u0010LJ\u0018\u0010M\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010N\u001a\u0004\u0018\u00010\u0017J!\u0010O\u001a\u00020$2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0007\u00a2\u0006\u0002\u0010PJ\u0016\u0010Q\u001a\u00020$2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010R\u001a\u00020$2\u0006\u00101\u001a\u000202J\u0016\u0010R\u001a\u00020$2\u0006\u00101\u001a\u0002022\u0006\u00106\u001a\u000207J(\u0010S\u001a\u00020\f2\u0006\u00101\u001a\u0002022\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0002JH\u0010T\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u0002050U2\u0006\u0010V\u001a\u00020\"2\u0006\u00101\u001a\u0002022\u0006\u00104\u001a\u0002052\u0018\u0010W\u001a\u0014\u0012\u0004\u0012\u00020X\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020$0!H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006Z"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient;", "", "()V", "DAEMON_CONNECT_CYCLE_ATTEMPTS", "", "getDAEMON_CONNECT_CYCLE_ATTEMPTS", "()I", "DAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "", "getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "()J", "verboseReporting", "", "getVerboseReporting", "()Z", "compile", "compilerService", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "sessionId", "targetPlatform", "Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;", "args", "", "", "out", "Ljava/io/OutputStream;", "port", "operationsTracer", "Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)I", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "outputsCollector", "Lkotlin/Function2;", "Ljava/io/File;", "", "", "compilerMode", "Lorg/jetbrains/kotlin/daemon/common/CompilerMode;", "reportSeverity", "Lorg/jetbrains/kotlin/daemon/common/ReportSeverity;", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lkotlin/jvm/functions/Function2;Lorg/jetbrains/kotlin/daemon/common/CompilerMode;Lorg/jetbrains/kotlin/daemon/common/ReportSeverity;ILorg/jetbrains/kotlin/daemon/common/Profiler;)I", "configureClientOptions", "Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "opts", "connectAndLease", "Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "clientAliveFlagFile", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "reportingTargets", "Lorg/jetbrains/kotlin/daemon/client/DaemonReportingTargets;", "autostart", "leaseSession", "sessionAliveFlagFile", "connectLoop", "R", "body", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/daemon/client/DaemonReportingTargets;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "connectToCompileService", "checkId", "detectCompilerClasspath", "getOrCreateClientFlagFile", "incrementalCompile", "compileService", "callbackServices", "Lorg/jetbrains/kotlin/daemon/client/CompilationServices;", "compilerOut", "daemonOut", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/client/CompilationServices;Ljava/io/OutputStream;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/daemon/common/Profiler;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)I", "leaseCompileSession", "aliveFlagPath", "main", "([Ljava/lang/String;)V", "releaseCompileSession", "shutdownCompileService", "startDaemon", "tryFindSuitableDaemonOrNewOpts", "Lkotlin/Pair;", "registryDir", "report", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "ClientOptions", "kotlin-daemon-client"})
public final class KotlinCompilerClient {
    @NotNull
    public static final KotlinCompilerClient INSTANCE = new KotlinCompilerClient();
    private static final long DAEMON_DEFAULT_STARTUP_TIMEOUT_MS = 10000L;
    private static final int DAEMON_CONNECT_CYCLE_ATTEMPTS = 3;
    private static final boolean verboseReporting = CompilerSystemProperties.COMPILE_DAEMON_VERBOSE_REPORT_PROPERTY.getValue() != null;

    private KotlinCompilerClient() {
    }

    public final long getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS() {
        return DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
    }

    public final int getDAEMON_CONNECT_CYCLE_ATTEMPTS() {
        return DAEMON_CONNECT_CYCLE_ATTEMPTS;
    }

    public final boolean getVerboseReporting() {
        return verboseReporting;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final File getOrCreateClientFlagFile(@NotNull DaemonOptions daemonOptions) {
        File file;
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        String string = CompilerSystemProperties.COMPILE_DAEMON_CLIENT_ALIVE_PATH_PROPERTY.getValue();
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            String string2 = DaemonParamsKt.trimQuotes(p0);
            if (string2 != null) {
                String string3;
                String string4;
                String p02 = string4 = string2;
                boolean bl2 = false;
                String string5 = string3 = !StringsKt.isBlank((CharSequence)p02) ? string4 : null;
                if (string3 != null) {
                    File file2;
                    File file3;
                    String p03 = string3;
                    boolean bl3 = false;
                    File p04 = file3 = new File(p03);
                    boolean bl4 = false;
                    File file4 = file2 = p04.exists() ? file3 : null;
                    if (file2 != null) {
                        file = file2;
                        return file;
                    }
                }
            }
        }
        file = ClientUtilsKt.makeAutodeletingFlagFile$default(null, new File(DaemonParamsKt.getRunFilesPathOrDefault(daemonOptions)), 1, null);
        return file;
    }

    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart, boolean checkId) {
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkNotNullParameter((Object)reportingTargets, (String)"reportingTargets");
        File flagFile = this.getOrCreateClientFlagFile(daemonOptions);
        return this.connectToCompileService(compilerId, flagFile, daemonJVMOptions, daemonOptions, reportingTargets, autostart);
    }

    public static /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, bl2);
    }

    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart) {
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
        Intrinsics.checkNotNullParameter((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkNotNullParameter((Object)reportingTargets, (String)"reportingTargets");
        CompileServiceSession compileServiceSession = this.connectAndLease(compilerId, clientAliveFlagFile, daemonJVMOptions, daemonOptions, reportingTargets, autostart, false, null);
        return compileServiceSession != null ? compileServiceSession.getCompileService() : null;
    }

    public static /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, File file, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, file, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final CompileServiceSession connectAndLease(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart, boolean leaseSession, @Nullable File sessionAliveFlagFile) {
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
        Intrinsics.checkNotNullParameter((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkNotNullParameter((Object)reportingTargets, (String)"reportingTargets");
        KotlinCompilerClient this_$iv = this;
        boolean $i$f$connectLoop = false;
        KotlinCompilerClient kotlinCompilerClient = this_$iv;
        synchronized (kotlinCompilerClient) {
            Object object;
            boolean bl = false;
            try {
                int n;
                int attempts$iv = 1;
                do {
                    Pair pair;
                    try {
                        CompileServiceSession compileServiceSession;
                        boolean isLastAttempt = attempts$iv >= DAEMON_CONNECT_CYCLE_ATTEMPTS;
                        boolean bl2 = false;
                        NetworkUtilsKt.ensureServerHostnameIsSetUp();
                        Pair<CompileService, DaemonJVMOptions> pair2 = INSTANCE.tryFindSuitableDaemonOrNewOpts(new File(daemonOptions.getRunFilesPath()), compilerId, daemonJVMOptions, (Function2<? super DaemonReportCategory, ? super String, Unit>)((Function2)new Function2<DaemonReportCategory, String, Unit>(reportingTargets){
                            final /* synthetic */ DaemonReportingTargets $reportingTargets;
                            {
                                this.$reportingTargets = $reportingTargets;
                                super(2);
                            }

                            public final void invoke(@NotNull DaemonReportCategory cat, @NotNull String msg2) {
                                Intrinsics.checkNotNullParameter((Object)((Object)cat), (String)"cat");
                                Intrinsics.checkNotNullParameter((Object)msg2, (String)"msg");
                                KotlinCompilerClientKt.report$default(this.$reportingTargets, cat, msg2, null, 4, null);
                            }
                        }));
                        CompileService service = (CompileService)pair2.component1();
                        DaemonJVMOptions newJVMOptions = (DaemonJVMOptions)pair2.component2();
                        if (service != null) {
                            compileServiceSession = KotlinCompilerClient.connectAndLease$lambda-5$leaseImpl(service, clientAliveFlagFile, reportingTargets, leaseSession, sessionAliveFlagFile);
                        } else {
                            if (!isLastAttempt && autostart && INSTANCE.startDaemon(compilerId, newJVMOptions, daemonOptions, reportingTargets)) {
                                KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.DEBUG, "new daemon started, trying to find it", null, 4, null);
                            }
                            compileServiceSession = null;
                        }
                        pair = TuplesKt.to((Object)compileServiceSession, null);
                    }
                    catch (SocketException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (ConnectException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (ConnectIOException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (UnmarshalException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    catch (RuntimeException e$iv) {
                        pair = TuplesKt.to(null, (Object)e$iv);
                    }
                    Pair pair3 = pair;
                    Object res$iv = pair3.component1();
                    Exception err$iv = (Exception)pair3.component2();
                    Object object2 = res$iv;
                    if (object2 != null) {
                        Object object3 = object2;
                        // MONITOREXIT @DISABLED, blocks:[1, 3, 10, 12] lbl55 : MonitorExitStatement: MONITOREXIT : var11_11
                        object = object3;
                        return (CompileServiceSession)object;
                    }
                    if (err$iv != null) {
                        KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, (attempts$iv >= DAEMON_CONNECT_CYCLE_ATTEMPTS || !autostart ? "no more retries on: " : "retrying(" + attempts$iv + ") on: ") + err$iv, null, 4, null);
                    }
                    n = attempts$iv++;
                } while (n <= DAEMON_CONNECT_CYCLE_ATTEMPTS && autostart);
                Object var23_29 = null;
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl65 : MonitorExitStatement: MONITOREXIT : var11_11
                object = var23_29;
                return (CompileServiceSession)object;
            }
            catch (Throwable e$iv) {
                KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.EXCEPTION, e$iv.toString(), null, 4, null);
                Object object4 = null;
                // MONITOREXIT @DISABLED, blocks:[3, 9] lbl71 : MonitorExitStatement: MONITOREXIT : var11_11
                object = object4;
                return (CompileServiceSession)object;
            }
        }
    }

    public static /* synthetic */ CompileServiceSession connectAndLease$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, File file, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, boolean bl2, File file2, int n, Object object) {
        if ((n & 0x80) != 0) {
            file2 = null;
        }
        return kotlinCompilerClient.connectAndLease(compilerId, file, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, bl2, file2);
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions) {
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        CompileService compileService = this.connectToCompileService(compilerId, new DaemonJVMOptions(null, null, null, null, 15, null), daemonOptions, new DaemonReportingTargets(System.out, null, null, null, 14, null), false, false);
        if (compileService != null) {
            compileService.shutdown();
        }
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId) {
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        this.shutdownCompileService(compilerId, new DaemonOptions(null, 0L, 0, 0, 0L, 0L, false, false, 255, null));
    }

    public final int leaseCompileSession(@NotNull CompileService compilerService, @Nullable String aliveFlagPath) {
        Intrinsics.checkNotNullParameter((Object)compilerService, (String)"compilerService");
        return ((Number)compilerService.leaseCompileSession(aliveFlagPath).get()).intValue();
    }

    public final void releaseCompileSession(@NotNull CompileService compilerService, int sessionId) {
        Intrinsics.checkNotNullParameter((Object)compilerService, (String)"compilerService");
        compilerService.releaseCompileSession(sessionId);
    }

    @Deprecated(message="Use other compile method", replaceWith=@ReplaceWith(expression="compile", imports={}))
    public final int compile(@NotNull CompileService compilerService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull OutputStream out, int port, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkNotNullParameter((Object)compilerService, (String)"compilerService");
        Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        RemoteOutputStreamServer outStrm = new RemoteOutputStreamServer(out, port);
        return ((Number)compilerService.remoteCompile(sessionId, targetPlatform, args, new CompilerCallbackServicesFacadeServer(null, null, null, null, null, null, null, port, 127, null), outStrm, CompileService.OutputFormat.PLAIN, outStrm, operationsTracer).get()).intValue();
    }

    public static /* synthetic */ int compile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, OutputStream outputStream, int n2, RemoteOperationsTracer remoteOperationsTracer, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x40) != 0) {
            remoteOperationsTracer = null;
        }
        return kotlinCompilerClient.compile(compileService, n, targetPlatform, stringArray, outputStream, n2, remoteOperationsTracer);
    }

    @Deprecated(message="Use non-deprecated compile method", replaceWith=@ReplaceWith(expression="compile", imports={}))
    public final int incrementalCompile(@NotNull CompileService compileService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilationServices callbackServices, @NotNull OutputStream compilerOut, @NotNull OutputStream daemonOut, int port, @NotNull Profiler profiler, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkNotNullParameter((Object)compileService, (String)"compileService");
        Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)callbackServices, (String)"callbackServices");
        Intrinsics.checkNotNullParameter((Object)compilerOut, (String)"compilerOut");
        Intrinsics.checkNotNullParameter((Object)daemonOut, (String)"daemonOut");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
        Profiler $this$withMeasure$iv = profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        int res$iv = ((Number)compileService.remoteIncrementalCompile(sessionId, targetPlatform, args, new CompilerCallbackServicesFacadeServer(callbackServices.getIncrementalCompilationComponents(), callbackServices.getLookupTracker(), callbackServices.getCompilationCanceledStatus(), null, null, null, null, port, 120, null), new RemoteOutputStreamServer(compilerOut, port), CompileService.OutputFormat.XML, new RemoteOutputStreamServer(daemonOut, port), operationsTracer).get()).intValue();
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    public static /* synthetic */ int incrementalCompile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, CompilationServices compilationServices, OutputStream outputStream, OutputStream outputStream2, int n2, Profiler profiler, RemoteOperationsTracer remoteOperationsTracer, int n3, Object object) {
        if ((n3 & 0x80) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x100) != 0) {
            profiler = new DummyProfiler();
        }
        if ((n3 & 0x200) != 0) {
            remoteOperationsTracer = null;
        }
        return kotlinCompilerClient.incrementalCompile(compileService, n, targetPlatform, stringArray, compilationServices, outputStream, outputStream2, n2, profiler, remoteOperationsTracer);
    }

    public final int compile(@NotNull CompileService compilerService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull MessageCollector messageCollector, @Nullable Function2<? super File, ? super List<? extends File>, Unit> outputsCollector, @NotNull CompilerMode compilerMode, @NotNull ReportSeverity reportSeverity, int port, @NotNull Profiler profiler) {
        Intrinsics.checkNotNullParameter((Object)compilerService, (String)"compilerService");
        Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)compilerMode, (String)"compilerMode");
        Intrinsics.checkNotNullParameter((Object)((Object)reportSeverity), (String)"reportSeverity");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
        Profiler $this$withMeasure$iv = profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        BasicCompilerServicesWithResultsFacadeServer services = new BasicCompilerServicesWithResultsFacadeServer(messageCollector, outputsCollector, port);
        Integer[] integerArray = new Integer[]{ReportCategory.COMPILER_MESSAGE.getCode(), ReportCategory.DAEMON_MESSAGE.getCode(), ReportCategory.EXCEPTION.getCode(), ReportCategory.OUTPUT_MESSAGE.getCode()};
        boolean $i$f$emptyArray = false;
        int res$iv = ((Number)compilerService.compile(sessionId, args, new CompilationOptions(compilerMode, targetPlatform, integerArray, reportSeverity.getCode(), (Integer[])((Object[])new Integer[0]), null, 32, null), services, null).get()).intValue();
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    public static /* synthetic */ int compile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, MessageCollector messageCollector, Function2 function2, CompilerMode compilerMode, ReportSeverity reportSeverity, int n2, Profiler profiler, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            function2 = null;
        }
        if ((n3 & 0x40) != 0) {
            compilerMode = CompilerMode.NON_INCREMENTAL_COMPILER;
        }
        if ((n3 & 0x80) != 0) {
            reportSeverity = ReportSeverity.INFO;
        }
        if ((n3 & 0x100) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x200) != 0) {
            profiler = new DummyProfiler();
        }
        return kotlinCompilerClient.compile(compileService, n, targetPlatform, stringArray, messageCollector, (Function2<? super File, ? super List<? extends File>, Unit>)function2, compilerMode, reportSeverity, n2, profiler);
    }

    private final ClientOptions configureClientOptions(ClientOptions opts) {
        String string = CompilerSystemProperties.COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY.getValue();
        if (string != null) {
            String it = string;
            boolean bl = false;
            String[] stringArray = new String[]{","};
            Iterable unrecognized = DaemonParamsKt.filterExtractProps$default(StringsKt.split$default((CharSequence)DaemonParamsKt.trimQuotes(it), (String[])stringArray, (boolean)false, (int)0, (int)6, null), opts.getMappers(), "", null, 4, null);
            if (CollectionsKt.any((Iterable)unrecognized)) {
                throw new IllegalArgumentException("Unrecognized client options passed via property " + CompilerSystemProperties.COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY.getProperty() + ": " + CollectionsKt.joinToString$default((Iterable)unrecognized, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "\nSupported options: " + CollectionsKt.joinToString$default((Iterable)opts.getMappers(), (CharSequence)", ", null, null, (int)0, null, (Function1)configureClientOptions.1.1.INSTANCE, (int)30, null));
            }
        }
        return opts;
    }

    private final ClientOptions configureClientOptions() {
        return this.configureClientOptions(new ClientOptions(false, 1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final void main(String ... args) {
        CompileService compileService;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        CompilerId compilerId = new CompilerId(null, null, 3, null);
        DaemonOptions daemonOptions = DaemonParamsKt.configureDaemonOptions();
        DaemonJVMOptions daemonLaunchingOptions = DaemonParamsKt.configureDaemonJVMOptions(new String[0], true, false, true);
        ClientOptions clientOptions = INSTANCE.configureClientOptions();
        OptionsGroup[] optionsGroupArray = new OptionsGroup[]{compilerId, daemonOptions, daemonLaunchingOptions, clientOptions};
        Iterable<String> filteredArgs = DaemonParamsKt.filterExtractProps(ArraysKt.asIterable((Object[])args), optionsGroupArray, "--daemon-");
        if (!clientOptions.getStop()) {
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                System.err.println("compiler wasn't explicitly specified, attempt to find appropriate jar");
                List<String> list = INSTANCE.detectCompilerClasspath();
                if (list != null) {
                    List<String> list2 = list;
                    boolean bl = false;
                    compilerId.setCompilerClasspath(list2);
                }
            }
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                throw new IllegalArgumentException("Cannot find compiler jar");
            }
            StringBuilder stringBuilder = new StringBuilder().append("desired compiler classpath: ");
            Iterable iterable = compilerId.getCompilerClasspath();
            String string = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
            System.out.println((Object)stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null)).toString());
        }
        if ((compileService = INSTANCE.connectToCompileService(compilerId, daemonLaunchingOptions, daemonOptions, new DaemonReportingTargets(System.out, null, null, null, 14, null), !clientOptions.getStop(), !clientOptions.getStop())) == null) {
            if (!clientOptions.getStop()) throw new Exception("Unable to connect to daemon");
            System.err.println("No daemon found to shut down");
            return;
        }
        if (clientOptions.getStop()) {
            System.out.println((Object)"Shutdown the daemon");
            compileService.shutdown();
            System.out.println((Object)"Daemon shut down successfully");
            return;
        }
        if (CollectionsKt.none(filteredArgs)) {
            System.out.println((Object)("Warning: empty arguments list, only daemon check is performed: checkCompilerId() returns " + compileService.checkCompilerId(compilerId)));
            return;
        }
        System.out.println((Object)("Executing daemon compilation with args: " + CollectionsKt.joinToString$default(filteredArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
        PrintStream printStream = System.out;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
        RemoteOutputStreamServer outStrm = new RemoteOutputStreamServer(printStream, 0, 2, null);
        CompilerCallbackServicesFacadeServer compilerCallbackServicesFacadeServer = new CompilerCallbackServicesFacadeServer(null, null, null, null, null, null, null, 0, 255, null);
        try {
            long memBefore = ((Number)compileService.getUsedMemory().get()).longValue() / (long)1024;
            long startTime = System.nanoTime();
            int n = CompileService.Companion.getNO_SESSION();
            Collection $this$toTypedArray$iv = CollectionsKt.toList(filteredArgs);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            CompileService.CallResult<Integer> res = compileService.remoteCompile(n, CompileService.TargetPlatform.JVM, stringArray, compilerCallbackServicesFacadeServer, outStrm, CompileService.OutputFormat.PLAIN, outStrm, null);
            long endTime = System.nanoTime();
            System.out.println((Object)("Compilation " + (res.isGood() ? "succeeded" : "failed") + ", result code: " + ((Number)res.get()).intValue()));
            long memAfter = ((Number)compileService.getUsedMemory().get()).longValue() / (long)1024;
            System.out.println((Object)("Compilation time: " + TimeUnit.NANOSECONDS.toMillis(endTime - startTime) + " ms"));
            StringBuilder stringBuilder = new StringBuilder().append("Used memory ").append(memAfter).append(" (");
            String string = "%+d";
            Object[] objectArray = new Object[]{memAfter - memBefore};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            System.out.println((Object)stringBuilder.append(string2).append(" kb)").toString());
            return;
        }
        finally {
            UnicastRemoteObject.unexportObject(compilerCallbackServicesFacadeServer, true);
            UnicastRemoteObject.unexportObject(outStrm, true);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final List<String> detectCompilerClasspath() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        String string = CompilerSystemProperties.JAVA_CLASS_PATH.getValue();
        if (string == null) return null;
        CharSequence charSequence = string;
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.pathSeparator, (String)"pathSeparator");
        List list = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (list == null) return null;
        Iterable iterable = list;
        boolean $i$f$map = false;
        File file = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File((String)it).getParentFile());
        }
        iterable = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        if (iterable == null) return null;
        $this$mapTo$iv$iv = iterable;
        boolean $i$f$mapNotNull = false;
        void $i$f$mapTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            File file2;
            FileTreeWalk fileTreeWalk;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            if (it != null && (fileTreeWalk = FilesKt.walk$default((File)it, null, (int)1, null)) != null) {
                Object v1;
                block5: {
                    void $this$firstOrNull$iv;
                    Sequence sequence2 = (Sequence)fileTreeWalk;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        File it2 = (File)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.equals((String)it2.getName(), (String)"kotlin-compiler.jar", (boolean)true)) continue;
                        v1 = element$iv;
                        break block5;
                    }
                    v1 = null;
                }
                file2 = v1;
            } else {
                file2 = null;
            }
            if (file2 == null) continue;
            File it$iv$iv = file2;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        file = (File)CollectionsKt.firstOrNull((List)((List)destination$iv$iv2));
        if (file == null) return null;
        File it = file;
        boolean bl = false;
        List list2 = CollectionsKt.listOf((Object)it.getAbsolutePath());
        return list2;
    }

    /*
     * Exception decompiling
     */
    private final <R> R connectLoop(DaemonReportingTargets reportingTargets, boolean autostart, Function1<? super Boolean, ? extends R> body) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Pair<CompileService, DaemonJVMOptions> tryFindSuitableDaemonOrNewOpts(File registryDir, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, Function2<? super DaemonReportCategory, ? super String, Unit> report2) {
        void $this$fold$iv;
        Pair pair;
        Object it;
        List list;
        registryDir.mkdirs();
        File timestampMarker = Files.createTempFile(registryDir.toPath(), "kotlin-daemon-client-tsmarker", null, new FileAttribute[0]).toFile();
        try {
            Intrinsics.checkNotNullExpressionValue((Object)timestampMarker, (String)"timestampMarker");
            list = SequencesKt.toList((Sequence)ClientUtilsKt.walkDaemons$default(registryDir, compilerId, timestampMarker, null, report2, 8, null));
        }
        finally {
            timestampMarker.delete();
        }
        List aliveWithMetadata = list;
        Comparator comparator = new DaemonJVMOptionsMemoryComparator();
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                Comparator comparator = this.$comparator;
                boolean bl = false;
                DaemonWithMetadata it = (DaemonWithMetadata)b;
                DaemonJVMOptions daemonJVMOptions = it.getJvmOptions();
                bl = false;
                DaemonJVMOptions daemonJVMOptions2 = it.getJvmOptions();
                return comparator.compare(daemonJVMOptions, daemonJVMOptions2);
            }
        };
        Comparator comparator2 = new FileAgeComparator();
        Comparator comparator3 = new Comparator(comparator, comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    DaemonWithMetadata it = (DaemonWithMetadata)b;
                    File file = it.getRunFile();
                    bl = false;
                    File file2 = it.getRunFile();
                    n = comparator.compare(file, file2);
                }
                return n;
            }
        };
        DaemonJVMOptions optsCopy = DaemonJVMOptions.copy$default(daemonJVMOptions, null, null, null, null, 15, null);
        DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)CollectionsKt.maxWith((Iterable)aliveWithMetadata, (Comparator)comparator3);
        if (daemonWithMetadata != null) {
            DaemonWithMetadata daemonWithMetadata2 = daemonWithMetadata;
            it = daemonWithMetadata2;
            boolean bl = false;
            daemonWithMetadata = DaemonParamsKt.memorywiseFitsInto(daemonJVMOptions, ((DaemonWithMetadata)it).getJvmOptions()) ? daemonWithMetadata2 : null;
            if (daemonWithMetadata != null) {
                DaemonWithMetadata it2 = daemonWithMetadata;
                boolean bl2 = false;
                pair = new Pair((Object)it2.getDaemon(), (Object)DaemonParamsKt.updateMemoryUpperBounds(optsCopy, it2.getJvmOptions()));
                return pair;
            }
        }
        it = aliveWithMetadata;
        Object var19_17 = null;
        boolean $i$f$fold = false;
        DaemonJVMOptions accumulator$iv = optsCopy;
        Iterator iterator2 = $this$fold$iv.iterator();
        while (true) {
            void d;
            if (!iterator2.hasNext()) {
                DaemonJVMOptions daemonJVMOptions2 = accumulator$iv;
                Object var21_24 = var19_17;
                pair = new Pair(var21_24, (Object)daemonJVMOptions2);
                return pair;
            }
            Object element$iv = iterator2.next();
            DaemonWithMetadata daemonWithMetadata3 = (DaemonWithMetadata)element$iv;
            DaemonJVMOptions opts = accumulator$iv;
            boolean bl = false;
            accumulator$iv = DaemonParamsKt.updateMemoryUpperBounds(opts, d.getJvmOptions());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final boolean startDaemon(CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets reportingTargets) {
        javaExecutable = new File(new File(CompilerSystemProperties.JAVA_HOME.getSafeValue(), "bin"), "java");
        v0 = CompilerSystemProperties.JAVA_RMI_SERVER_HOSTNAME.getValue();
        if (v0 == null) {
            throw new IllegalStateException((CompilerSystemProperties.JAVA_RMI_SERVER_HOSTNAME.getProperty() + " is not set!").toString());
        }
        serverHostname = v0;
        var8_7 = new String[]{"-Djava.awt.headless=true", "-D$" + CompilerSystemProperties.JAVA_RMI_SERVER_HOSTNAME.getProperty() + '=' + serverHostname};
        platformSpecificOptions = CollectionsKt.listOf((Object[])var8_7);
        v1 = CompilerSystemProperties.JAVA_VERSION.getValue();
        v2 = javaVersion = v1 != null ? StringsKt.toIntOrNull((String)v1) : null;
        if (javaVersion != null && javaVersion >= 16) {
            var10_9 = new String[]{"--add-exports", "java.base/sun.nio.ch=ALL-UNNAMED"};
            v3 = CollectionsKt.listOf((Object[])var10_9);
        } else {
            v3 = CollectionsKt.emptyList();
        }
        javaIllegalAccessWorkaround = v3;
        var11_11 /* !! */  = new String[3];
        var11_11 /* !! */ [0] = javaExecutable.getAbsolutePath();
        var11_11 /* !! */ [1] = "-cp";
        v4 = compilerId.getCompilerClasspath();
        v5 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"pathSeparator");
        var11_11 /* !! */ [2] = CollectionsKt.joinToString$default((Iterable)v4, (CharSequence)v5, null, null, (int)0, null, null, (int)62, null);
        v6 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])var11_11 /* !! */ ), (Iterable)platformSpecificOptions);
        var11_11 /* !! */  = daemonJVMOptions.getMappers();
        var24_12 = v6;
        $i$f$flatMap = false;
        var13_15 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        var16_19 = $this$flatMapTo$iv$iv.iterator();
        while (var16_19.hasNext()) {
            element$iv$iv = var16_19.next();
            it = (PropMapper)element$iv$iv;
            $i$a$-flatMap-KotlinCompilerClient$startDaemon$args$1 = false;
            list$iv$iv = it.toArgs("-");
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = daemonOptions.getMappers();
        var24_12 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)var24_12, (Iterable)((List)destination$iv$iv)), (Iterable)javaIllegalAccessWorkaround), (Object)"org.jetbrains.kotlin.daemon.KotlinCompileDaemon");
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        var16_19 = $this$flatMapTo$iv$iv.iterator();
        while (var16_19.hasNext()) {
            element$iv$iv = var16_19.next();
            it = (PropMapper)element$iv$iv;
            $i$a$-flatMap-KotlinCompilerClient$startDaemon$args$2 = false;
            list$iv$iv = it.toArgs("--daemon-");
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = compilerId.getMappers();
        var24_12 = CollectionsKt.plus((Collection)var24_12, (Iterable)((List)destination$iv$iv));
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        var16_19 = $this$flatMapTo$iv$iv.iterator();
        while (var16_19.hasNext()) {
            element$iv$iv = var16_19.next();
            it = (PropMapper)element$iv$iv;
            $i$a$-flatMap-KotlinCompilerClient$startDaemon$args$3 = false;
            list$iv$iv = it.toArgs("--daemon-");
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        args = CollectionsKt.plus((Collection)var24_12, (Iterable)((List)destination$iv$iv));
        KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.DEBUG, "starting the daemon as: " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), null, 4, null);
        processBuilder = new ProcessBuilder(args);
        processBuilder.redirectErrorStream(true);
        $this$startDaemon_u24lambda_u2d23 = $this$flatMapTo$iv$iv = new File(daemonOptions.getRunFilesPath());
        $i$a$-apply-KotlinCompilerClient$startDaemon$workingDir$1 = false;
        $this$startDaemon_u24lambda_u2d23.mkdirs();
        workingDir = $this$flatMapTo$iv$iv;
        processBuilder.directory((File)workingDir);
        daemon = NativePlatformUtilKt.launchProcessWithFallback(processBuilder, reportingTargets, "daemon client");
        isEchoRead = new Semaphore(1);
        isEchoRead.acquire();
        stdoutThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(daemon, isEchoRead, reportingTargets){
            final /* synthetic */ Process $daemon;
            final /* synthetic */ Semaphore $isEchoRead;
            final /* synthetic */ DaemonReportingTargets $reportingTargets;
            {
                this.$daemon = $daemon;
                this.$isEchoRead = $isEchoRead;
                this.$reportingTargets = $reportingTargets;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    InputStream inputStream = this.$daemon.getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"daemon.inputStream");
                    InputStream inputStream2 = inputStream;
                    Charset charset = Charsets.UTF_8;
                    TextStreamsKt.forEachLine((Reader)new InputStreamReader(inputStream2, charset), (Function1)((Function1)new Function1<String, Unit>(this.$reportingTargets, this.$isEchoRead){
                        final /* synthetic */ DaemonReportingTargets $reportingTargets;
                        final /* synthetic */ Semaphore $isEchoRead;
                        {
                            this.$reportingTargets = $reportingTargets;
                            this.$isEchoRead = $isEchoRead;
                            super(1);
                        }

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            if (Thread.currentThread().isInterrupted()) {
                                return;
                            }
                            if (Intrinsics.areEqual((Object)it, (Object)"Kotlin compile daemon is ready")) {
                                KotlinCompilerClientKt.report$default(this.$reportingTargets, DaemonReportCategory.DEBUG, "Received the message signalling that the daemon is ready", null, 4, null);
                                this.$isEchoRead.release();
                                return;
                            }
                            KotlinCompilerClientKt.report(this.$reportingTargets, DaemonReportCategory.INFO, it, "daemon");
                        }
                    }));
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.$daemon.getInputStream().close();
                    this.$daemon.getOutputStream().close();
                    this.$daemon.getErrorStream().close();
                    this.$isEchoRead.release();
                }
            }
        }), (int)31, null);
        try {
            v7 = CompilerSystemProperties.COMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY.getValue();
            if (v7 == null) ** GOTO lbl-1000
            it = v7;
            $i$a$-let-KotlinCompilerClient$startDaemon$daemonStartupTimeout$1 = false;
            try {
                var22_29 = Long.parseLong(it);
            }
            catch (Exception e) {
                KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, "unable to interpret " + CompilerSystemProperties.COMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY.getProperty() + " property ('" + it + "'); using default timeout " + KotlinCompilerClient.DAEMON_DEFAULT_STARTUP_TIMEOUT_MS + " ms", null, 4, null);
                var22_29 = null;
            }
            v8 = var22_29;
            v7 = v8;
            if (v8 != null) {
                v9 = v7.longValue();
            } else lbl-1000:
            // 2 sources

            {
                v9 = daemonStartupTimeout = KotlinCompilerClient.DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
            }
            if (((CharSequence)daemonOptions.getRunFilesPath()).length() > 0) {
                succeeded = isEchoRead.tryAcquire(daemonStartupTimeout, TimeUnit.MILLISECONDS);
                if (!KotlinCompilerClientKt.isProcessAlive(daemon)) {
                    KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, "Daemon terminated unexpectedly with error code: " + daemon.exitValue(), null, 4, null);
                    v10 = false;
                } else if (!succeeded) {
                    KotlinCompilerClientKt.report$default(reportingTargets, DaemonReportCategory.INFO, "Unable to get response from daemon in " + daemonStartupTimeout + " ms", null, 4, null);
                    v10 = false;
                } else {
                    v10 = true;
                }
                var19_26 = v10;
                return var19_26;
            }
            Thread.sleep(daemonStartupTimeout);
            var18_25 = true;
            return var18_25;
        }
        finally {
            block20: {
                if (stdoutThread.isAlive()) {
                    stdoutThread.interrupt();
                }
                v11 = reportingTargets.getOut();
                if (v11 == null) break block20;
                v11.flush();
            }
        }
    }

    private static final CompileServiceSession connectAndLease$lambda-5$leaseImpl(CompileService $this$connectAndLease_u24lambda_u2d5_u24leaseImpl, File $clientAliveFlagFile, DaemonReportingTargets $reportingTargets, boolean $leaseSession, File $sessionAliveFlagFile) {
        CompileServiceSession compileServiceSession;
        CompileService.CallResult<Integer> callResult;
        $this$connectAndLease_u24lambda_u2d5_u24leaseImpl.registerClient($clientAliveFlagFile.getAbsolutePath());
        KotlinCompilerClientKt.report$default($reportingTargets, DaemonReportCategory.DEBUG, "connected to the daemon", null, 4, null);
        if (!$leaseSession) {
            return new CompileServiceSession($this$connectAndLease_u24lambda_u2d5_u24leaseImpl, CompileService.Companion.getNO_SESSION());
        }
        File file = $sessionAliveFlagFile;
        CompileService.CallResult<Integer> it = callResult = $this$connectAndLease_u24lambda_u2d5_u24leaseImpl.leaseCompileSession(file != null ? file.getAbsolutePath() : null);
        boolean bl = false;
        CompileService.CallResult<Integer> callResult2 = !(it instanceof CompileService.CallResult.Dying) ? callResult : null;
        if (callResult2 != null) {
            it = callResult2;
            boolean bl2 = false;
            compileServiceSession = new CompileServiceSession($this$connectAndLease_u24lambda_u2d5_u24leaseImpl, ((Number)it.get()).intValue());
        } else {
            compileServiceSession = null;
        }
        return compileServiceSession;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R&\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "Lorg/jetbrains/kotlin/daemon/common/OptionsGroup;", "stop", "", "(Z)V", "mappers", "", "Lorg/jetbrains/kotlin/daemon/common/PropMapper;", "getMappers", "()Ljava/util/List;", "getStop", "()Z", "setStop", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "kotlin-daemon-client"})
    public static final class ClientOptions
    implements OptionsGroup {
        private boolean stop;

        public ClientOptions(boolean stop) {
            this.stop = stop;
        }

        public /* synthetic */ ClientOptions(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean getStop() {
            return this.stop;
        }

        public final void setStop(boolean bl) {
            this.stop = bl;
        }

        @Override
        @NotNull
        public List<PropMapper<?, ?, ?>> getMappers() {
            return CollectionsKt.listOf(new BoolPropMapper(this, (KMutableProperty1)mappers.1.INSTANCE, null, 4, null));
        }

        public final boolean component1() {
            return this.stop;
        }

        @NotNull
        public final ClientOptions copy(boolean stop) {
            return new ClientOptions(stop);
        }

        public static /* synthetic */ ClientOptions copy$default(ClientOptions clientOptions, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = clientOptions.stop;
            }
            return clientOptions.copy(bl);
        }

        @NotNull
        public String toString() {
            return "ClientOptions(stop=" + this.stop + ')';
        }

        public int hashCode() {
            int n = this.stop ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClientOptions)) {
                return false;
            }
            ClientOptions clientOptions = (ClientOptions)other;
            return this.stop == clientOptions.stop;
        }

        public ClientOptions() {
            this(false, 1, null);
        }
    }
}

