/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.incremental.ClassProtoData;
import org.jetbrains.kotlin.incremental.KotlinClassInfoKt;
import org.jetbrains.kotlin.incremental.LocalFileKotlinClass;
import org.jetbrains.kotlin.incremental.ProtoData;
import org.jetbrains.kotlin.incremental.ProtoDifferenceUtilsKt;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValue;
import org.jetbrains.kotlin.inline.InlineFunctionOrAccessor;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.jvm.deserialization.BitEncoding;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMemberSignature;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 62\u00020\u0001:\u00016Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\b\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\f\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\u0002\u0010\u0010R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u0019\u001a\u00020\u001a8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\u001f\u001a\u0004\u0018\u00010\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001e\u001a\u0004\b \u0010\u0016R#\u0010\"\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010#8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u001e\u001a\u0004\b$\u0010%R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010(R\u0013\u0010\n\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001b\u0010,\u001a\u00020-8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\u001e\u001a\u0004\b.\u0010/R\u001b\u00101\u001a\u0002028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\u001e\u001a\u0004\b3\u00104\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/incremental/KotlinClassInfo;", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "classKind", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader$Kind;", "classHeaderData", "", "", "classHeaderStrings", "multifileClassName", "constantsMap", "", "inlineFunctionsAndAccessorsMap", "Lorg/jetbrains/kotlin/inline/InlineFunctionOrAccessor;", "", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader$Kind;[Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;)V", "getClassHeaderData", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getClassHeaderStrings", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "getClassKind", "()Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader$Kind;", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "getClassName", "()Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "className$delegate", "Lkotlin/Lazy;", "companionObject", "getCompanionObject", "companionObject$delegate", "constantsInCompanionObject", "", "getConstantsInCompanionObject", "()Ljava/util/List;", "constantsInCompanionObject$delegate", "getConstantsMap", "()Ljava/util/Map;", "getInlineFunctionsAndAccessorsMap", "getMultifileClassName", "()Ljava/lang/String;", "protoData", "Lorg/jetbrains/kotlin/incremental/ProtoData;", "getProtoData", "()Lorg/jetbrains/kotlin/incremental/ProtoData;", "protoData$delegate", "protoMapValue", "Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValue;", "getProtoMapValue", "()Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValue;", "protoMapValue$delegate", "Companion", "kotlin-build-common"})
public final class KotlinClassInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassId classId;
    @NotNull
    private final KotlinClassHeader.Kind classKind;
    @NotNull
    private final String[] classHeaderData;
    @NotNull
    private final String[] classHeaderStrings;
    @Nullable
    private final String multifileClassName;
    @NotNull
    private final Map<String, Object> constantsMap;
    @NotNull
    private final Map<InlineFunctionOrAccessor, Long> inlineFunctionsAndAccessorsMap;
    @NotNull
    private final Lazy className$delegate;
    @NotNull
    private final Lazy protoMapValue$delegate;
    @NotNull
    private final Lazy protoData$delegate;
    @NotNull
    private final Lazy companionObject$delegate;
    @NotNull
    private final Lazy constantsInCompanionObject$delegate;

    public KotlinClassInfo(@NotNull ClassId classId, @NotNull KotlinClassHeader.Kind classKind, @NotNull String[] classHeaderData, @NotNull String[] classHeaderStrings, @Nullable String multifileClassName, @NotNull Map<String, ? extends Object> constantsMap, @NotNull Map<InlineFunctionOrAccessor, Long> inlineFunctionsAndAccessorsMap) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        Intrinsics.checkNotNullParameter((Object)classKind, (String)"classKind");
        Intrinsics.checkNotNullParameter((Object)classHeaderData, (String)"classHeaderData");
        Intrinsics.checkNotNullParameter((Object)classHeaderStrings, (String)"classHeaderStrings");
        Intrinsics.checkNotNullParameter(constantsMap, (String)"constantsMap");
        Intrinsics.checkNotNullParameter(inlineFunctionsAndAccessorsMap, (String)"inlineFunctionsAndAccessorsMap");
        this.classId = classId;
        this.classKind = classKind;
        this.classHeaderData = classHeaderData;
        this.classHeaderStrings = classHeaderStrings;
        this.multifileClassName = multifileClassName;
        this.constantsMap = constantsMap;
        this.inlineFunctionsAndAccessorsMap = inlineFunctionsAndAccessorsMap;
        this.className$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JvmClassName>(this){
            final /* synthetic */ KotlinClassInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final JvmClassName invoke() {
                JvmClassName jvmClassName = JvmClassName.byClassId((ClassId)this.this$0.getClassId());
                Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byClassId(classId)");
                return jvmClassName;
            }
        }));
        this.protoMapValue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProtoMapValue>(this){
            final /* synthetic */ KotlinClassInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ProtoMapValue invoke() {
                boolean bl = this.this$0.getClassKind() != KotlinClassHeader.Kind.CLASS;
                byte[] byArray = BitEncoding.decodeBytes((String[])this.this$0.getClassHeaderData());
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decodeBytes(classHeaderData)");
                return new ProtoMapValue(bl, byArray, this.this$0.getClassHeaderStrings());
            }
        }));
        this.protoData$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ProtoData>(this){
            final /* synthetic */ KotlinClassInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ProtoData invoke() {
                boolean bl = this.this$0.getClassKind() != KotlinClassHeader.Kind.MULTIFILE_CLASS;
                KotlinClassInfo kotlinClassInfo = this.this$0;
                if (!bl) {
                    boolean bl2 = false;
                    String string = "Proto data is not available for KotlinClassHeader.Kind.MULTIFILE_CLASS: " + kotlinClassInfo.getClassId();
                    throw new IllegalStateException(string.toString());
                }
                ProtoMapValue protoMapValue2 = this.this$0.getProtoMapValue();
                FqName fqName = this.this$0.getClassId().getPackageFqName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"classId.packageFqName");
                return ProtoDifferenceUtilsKt.toProtoData(protoMapValue2, fqName);
            }
        }));
        this.companionObject$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ClassId>(this){
            final /* synthetic */ KotlinClassInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final ClassId invoke() {
                ClassId classId;
                if (this.this$0.getClassKind() == KotlinClassHeader.Kind.CLASS) {
                    ProtoData protoData2 = this.this$0.getProtoData();
                    Intrinsics.checkNotNull((Object)protoData2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.incremental.ClassProtoData");
                    String string = ProtoDifferenceUtilsKt.getCompanionObjectName((ClassProtoData)protoData2);
                    if (string != null) {
                        String string2 = string;
                        KotlinClassInfo kotlinClassInfo = this.this$0;
                        String it = string2;
                        boolean bl = false;
                        classId = kotlinClassInfo.getClassId().createNestedClassId(Name.identifier((String)it));
                    } else {
                        classId = null;
                    }
                } else {
                    classId = null;
                }
                return classId;
            }
        }));
        this.constantsInCompanionObject$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ KotlinClassInfo this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final List<String> invoke() {
                List<String> list;
                if (this.this$0.getClassKind() == KotlinClassHeader.Kind.CLASS) {
                    ProtoData protoData2 = this.this$0.getProtoData();
                    Intrinsics.checkNotNull((Object)protoData2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.incremental.ClassProtoData");
                    ClassProtoData classProtoData = (ClassProtoData)protoData2;
                    list = ProtoDifferenceUtilsKt.isCompanionObject(classProtoData.getProto()) ? ProtoDifferenceUtilsKt.getConstants(classProtoData) : null;
                } else {
                    list = null;
                }
                return list;
            }
        }));
    }

    @NotNull
    public final ClassId getClassId() {
        return this.classId;
    }

    @NotNull
    public final KotlinClassHeader.Kind getClassKind() {
        return this.classKind;
    }

    @NotNull
    public final String[] getClassHeaderData() {
        return this.classHeaderData;
    }

    @NotNull
    public final String[] getClassHeaderStrings() {
        return this.classHeaderStrings;
    }

    @Nullable
    public final String getMultifileClassName() {
        return this.multifileClassName;
    }

    @NotNull
    public final Map<String, Object> getConstantsMap() {
        return this.constantsMap;
    }

    @NotNull
    public final Map<InlineFunctionOrAccessor, Long> getInlineFunctionsAndAccessorsMap() {
        return this.inlineFunctionsAndAccessorsMap;
    }

    @NotNull
    public final JvmClassName getClassName() {
        Lazy lazy = this.className$delegate;
        return (JvmClassName)lazy.getValue();
    }

    @NotNull
    public final ProtoMapValue getProtoMapValue() {
        Lazy lazy = this.protoMapValue$delegate;
        return (ProtoMapValue)lazy.getValue();
    }

    @NotNull
    public final ProtoData getProtoData() {
        Lazy lazy = this.protoData$delegate;
        return (ProtoData)lazy.getValue();
    }

    @Nullable
    public final ClassId getCompanionObject() {
        Lazy lazy = this.companionObject$delegate;
        return (ClassId)lazy.getValue();
    }

    @Nullable
    public final List<String> getConstantsInCompanionObject() {
        Lazy lazy = this.constantsInCompanionObject$delegate;
        return (List)lazy.getValue();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/incremental/KotlinClassInfo$Companion;", "", "()V", "createFrom", "Lorg/jetbrains/kotlin/incremental/KotlinClassInfo;", "kotlinClass", "Lorg/jetbrains/kotlin/incremental/LocalFileKotlinClass;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "classHeader", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "classContents", "", "kotlin-build-common"})
    @SourceDebugExtension(value={"SMAP\nKotlinClassInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinClassInfo.kt\norg/jetbrains/kotlin/incremental/KotlinClassInfo$Companion\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,207:1\n26#2:208\n26#2:209\n468#3:210\n414#3:211\n1238#4,4:212\n*S KotlinDebug\n*F\n+ 1 KotlinClassInfo.kt\norg/jetbrains/kotlin/incremental/KotlinClassInfo$Companion\n*L\n92#1:208\n93#1:209\n95#1:210\n95#1:211\n95#1:212,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinClassInfo createFrom(@NotNull LocalFileKotlinClass kotlinClass) {
            Intrinsics.checkNotNullParameter((Object)((Object)kotlinClass), (String)"kotlinClass");
            ClassId classId = kotlinClass.getClassId();
            Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"kotlinClass.classId");
            KotlinClassHeader kotlinClassHeader = kotlinClass.getClassHeader();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinClassHeader, (String)"kotlinClass.classHeader");
            return this.createFrom(classId, kotlinClassHeader, kotlinClass.getFileContents());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final KotlinClassInfo createFrom(@NotNull ClassId classId, @NotNull KotlinClassHeader classHeader, @NotNull byte[] classContents) {
            Map map;
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            String[] stringArray;
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            Intrinsics.checkNotNullParameter((Object)classHeader, (String)"classHeader");
            Intrinsics.checkNotNullParameter((Object)classContents, (String)"classContents");
            Pair pair = KotlinClassInfoKt.access$getConstantsAndInlineFunctionsOrAccessors(classHeader, classContents);
            Map constants = (Map)pair.component1();
            Map inlineFunctionsAndAccessors = (Map)pair.component2();
            KotlinClassHeader.Kind kind = classHeader.getKind();
            String[] stringArray2 = classHeader.getData();
            if (stringArray2 == null && (stringArray2 = classHeader.getIncompatibleData()) == null) {
                boolean $i$f$emptyArray = false;
                stringArray2 = new String[]{};
            }
            if ((stringArray = classHeader.getStrings()) == null) {
                boolean $i$f$emptyArray = false;
                stringArray = new String[]{};
            }
            Map map2 = constants;
            String string = classHeader.getMultifileClassName();
            String[] stringArray3 = stringArray;
            String[] stringArray4 = stringArray2;
            KotlinClassHeader.Kind kind2 = kind;
            ClassId classId2 = classId;
            boolean $i$f$mapKeys = false;
            void $i$f$emptyArray = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                map = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                String string2 = ((JvmMemberSignature.Field)it.getKey()).getName();
                Map map3 = map;
                boolean bl2 = false;
                entry = it$iv$iv.getValue();
                map3.put(string2, entry);
            }
            map = destination$iv$iv;
            Map map4 = inlineFunctionsAndAccessors;
            Map map5 = map;
            String string3 = string;
            String[] stringArray5 = stringArray3;
            String[] stringArray6 = stringArray4;
            KotlinClassHeader.Kind kind3 = kind2;
            ClassId classId3 = classId2;
            return new KotlinClassInfo(classId3, kind3, stringArray6, stringArray5, string3, map5, map4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

