/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.ClassDiagnosticRetriever;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnostics;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FirElementsRecorder;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.NonReanalyzableDeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.NonReanalyzableNonClassDeclarationStructureElement;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.impl.FirErrorConstructor;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/NonReanalyzableClassDeclarationStructureElement;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/NonReanalyzableDeclarationStructureElement;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "fir", "psi", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "moduleComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;)V", "diagnostics", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnostics;", "getDiagnostics", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnostics;", "getPsi", "()Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Recorder", "low-level-api-fir"})
public final class NonReanalyzableClassDeclarationStructureElement
extends NonReanalyzableDeclarationStructureElement<FirRegularClass> {
    @NotNull
    private final KtClassOrObject psi;
    @NotNull
    private final FileStructureElementDiagnostics diagnostics;

    public NonReanalyzableClassDeclarationStructureElement(@NotNull FirFile firFile, @NotNull FirRegularClass fir, @NotNull KtClassOrObject psi2, @NotNull LLFirModuleResolveComponents moduleComponents) {
        Intrinsics.checkNotNullParameter((Object)firFile, (String)"firFile");
        Intrinsics.checkNotNullParameter((Object)fir, (String)"fir");
        Intrinsics.checkNotNullParameter((Object)psi2, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)moduleComponents, (String)"moduleComponents");
        super((FirDeclaration)fir, firFile, moduleComponents, null);
        this.psi = psi2;
        this.diagnostics = new FileStructureElementDiagnostics(firFile, new ClassDiagnosticRetriever((FirRegularClass)this.getFirDeclaration()), moduleComponents);
    }

    @NotNull
    public KtClassOrObject getPsi() {
        return this.psi;
    }

    @Override
    @NotNull
    public FileStructureElementDiagnostics getDiagnostics() {
        return this.diagnostics;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016J$\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016J$\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016J$\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00032\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016J$\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016J$\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/NonReanalyzableClassDeclarationStructureElement$Recorder;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FirElementsRecorder;", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "visitAnonymousInitializer", "", "anonymousInitializer", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousInitializer;", "data", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitRegularClass", "regularClass", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "low-level-api-fir"})
    public static final class Recorder
    extends FirElementsRecorder {
        @NotNull
        private final FirRegularClass firClass;

        public Recorder(@NotNull FirRegularClass firClass) {
            Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
            this.firClass = firClass;
        }

        public void visitProperty(@NotNull FirProperty property, @NotNull Map<KtElement, FirElement> data) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            KtSourceElement ktSourceElement = property.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                super.visitProperty(property, data);
            }
        }

        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull Map<KtElement, FirElement> data) {
            Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            Intrinsics.checkNotNullParameter(data, (String)"data");
        }

        public void visitConstructor(@NotNull FirConstructor constructor, @NotNull Map<KtElement, FirElement> data) {
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (constructor instanceof FirPrimaryConstructor || constructor instanceof FirErrorConstructor) {
                KtSourceElement ktSourceElement = constructor.getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitConstructor.INSTANCE)) {
                    NonReanalyzableNonClassDeclarationStructureElement.Recorder.INSTANCE.visitConstructor(constructor, data);
                }
            }
        }

        public void visitAnonymousInitializer(@NotNull FirAnonymousInitializer anonymousInitializer, @NotNull Map<KtElement, FirElement> data) {
            Intrinsics.checkNotNullParameter((Object)anonymousInitializer, (String)"anonymousInitializer");
            Intrinsics.checkNotNullParameter(data, (String)"data");
        }

        public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull Map<KtElement, FirElement> data) {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (!Intrinsics.areEqual((Object)regularClass, (Object)this.firClass)) {
                return;
            }
            super.visitRegularClass(regularClass, data);
        }

        public void visitTypeAlias(@NotNull FirTypeAlias typeAlias, @NotNull Map<KtElement, FirElement> data) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            Intrinsics.checkNotNullParameter(data, (String)"data");
        }
    }
}

