/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.project.structure;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.project.structure.DanglingFileResolutionMode;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtModuleInternalUtilsKt;
import org.jetbrains.kotlin.analysis.project.structure.KtNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.project.structure.ProjectStructureProviderKt;
import org.jetbrains.kotlin.analysis.project.structure.impl.KtDanglingFileModuleImpl;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005H&J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH$J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0012H\u0002R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/project/structure/ProjectStructureProvider;", "", "<init>", "()V", "getModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "element", "Lcom/intellij/psi/PsiElement;", "contextualModule", "getNotUnderContentRootModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtNotUnderContentRootModule;", "project", "Lcom/intellij/openapi/project/Project;", "computeSpecialModule", "file", "Lcom/intellij/psi/PsiFile;", "computeDefaultDanglingFileResolutionMode", "Lorg/jetbrains/kotlin/analysis/project/structure/DanglingFileResolutionMode;", "Lorg/jetbrains/kotlin/psi/KtFile;", "computeContextModule", "globalLanguageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getGlobalLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "libraryLanguageVersionSettings", "getLibraryLanguageVersionSettings", "Companion", "project-structure"})
@SourceDebugExtension(value={"SMAP\nProjectStructureProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectStructureProvider.kt\norg/jetbrains/kotlin/analysis/project/structure/ProjectStructureProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n1#2:171\n*E\n"})
public abstract class ProjectStructureProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract KtModule getModule(@NotNull PsiElement var1, @Nullable KtModule var2);

    @NotNull
    protected abstract KtNotUnderContentRootModule getNotUnderContentRootModule(@NotNull Project var1);

    @Nullable
    protected final KtModule computeSpecialModule(@NotNull PsiFile file) {
        KtModule contextModule;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && (contextModule = KtModuleInternalUtilsKt.getAnalysisExtensionFileContextModule(virtualFile)) != null) {
            return contextModule;
        }
        if (file instanceof KtFile && ProjectStructureProviderKt.isDangling((KtFile)file)) {
            contextModule = this.computeContextModule((KtFile)file);
            DanglingFileResolutionMode danglingFileResolutionMode = ProjectStructureProviderKt.getDanglingFileResolutionMode((KtFile)file);
            if (danglingFileResolutionMode == null) {
                danglingFileResolutionMode = this.computeDefaultDanglingFileResolutionMode((KtFile)file);
            }
            DanglingFileResolutionMode resolutionMode = danglingFileResolutionMode;
            return new KtDanglingFileModuleImpl((KtFile)file, contextModule, resolutionMode);
        }
        return null;
    }

    private final DanglingFileResolutionMode computeDefaultDanglingFileResolutionMode(KtFile file) {
        if (!(file.isPhysical() || file.getViewProvider().isEventSystemEnabled() || Intrinsics.areEqual((Object)file.getOriginalFile(), (Object)file))) {
            return DanglingFileResolutionMode.IGNORE_SELF;
        }
        return DanglingFileResolutionMode.PREFER_SELF;
    }

    private final KtModule computeContextModule(KtFile file) {
        PsiElement contextElement;
        PsiElement psiElement = file.getContext();
        if (psiElement == null && (psiElement = KtPsiFactoryKt.getAnalysisContext((KtFile)file)) == null) {
            PsiFile psiFile;
            PsiFile it = psiFile = file.getOriginalFile();
            boolean bl = false;
            psiElement = (PsiElement)(it != file ? psiFile : null);
        }
        if ((contextElement = psiElement) != null) {
            return this.getModule(contextElement, null);
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.getNotUnderContentRootModule(project);
    }

    @NotNull
    public LanguageVersionSettings getGlobalLanguageVersionSettings() {
        return (LanguageVersionSettings)LanguageVersionSettingsImpl.DEFAULT;
    }

    @NotNull
    public LanguageVersionSettings getLibraryLanguageVersionSettings() {
        return this.getGlobalLanguageVersionSettings();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/analysis/project/structure/ProjectStructureProvider$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/analysis/project/structure/ProjectStructureProvider;", "project", "Lcom/intellij/openapi/project/Project;", "getModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "element", "Lcom/intellij/psi/PsiElement;", "contextualModule", "project-structure"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProjectStructureProvider getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ProjectStructureProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ProjectStructureProvider)object;
        }

        @NotNull
        public final KtModule getModule(@NotNull Project project, @NotNull PsiElement element, @Nullable KtModule contextualModule) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this.getInstance(project).getModule(element, contextualModule);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

